function [vardraw,r_pt,q_pt]=draw_var(x,r_pt,q_pt,var_min,params);
r_p=params(1); r_m1=params(2); r_m2=params(3); r_sig=params(4); r_sig2=params(5); q_p=params(6); q1=params(7); q2=params(8); tau1=params(9); tau2=params(10); vague=params(11);
n=size(x,1);
bsum=tril(ones(n+1,n+1));
lnres2=log(x.^2);
     
%Step 1 -- initial draws of Indicator Variables %
 tmp=rand(n,1);
 ir = tmp<r_pt;
 tmp=rand(n,1);
 iq = tmp<q_pt;
 
% Step 2; compute system parameters given indicators %
 mut = (ir*r_m1) + ((1-ir)*r_m2);
 qt = (iq*q1) + ((1-iq)*q2);

% Compute Covariance Matrix  % 
 vd=diag([vague;qt]);  
 valpha=bsum*vd*bsum';
 vy=valpha(2:n+1,2:n+1);
 cy=valpha(1:n+1,2:n+1);
 diagvy=diag(vy)+r_sig2;
 for i=1:n; vy(i,i)=diagvy(i); end;
 vyi=inv(vy);
 kgain=cy*vyi;

%Compute draws of state and shocks %
 ye=lnres2-mut;
 ahat0=kgain*ye;
 ahat1=ahat0(2:n+1);
 vhat0=valpha-kgain*cy';
 cvhat0=chol(vhat0);
 adraw0=ahat0+cvhat0'*randn(n+1,1);
 adraw1=adraw0(2:n+1);
 edraw=lnres2-adraw1;
 udraw=adraw0(2:n+1)-adraw0(1:n);

% Compute Mixture Probabilities %
  f1=exp(   (-0.5)* (((edraw-r_m1)./r_sig).^2)  );
  f2=exp(   (-0.5)* (((edraw-r_m2)./r_sig).^2)  );
  fe= r_p*f1 + (1-r_p)*f2;
  r_pt=(r_p*f1)./fe;
  
% u shocks -- Means are both zero%
  f1=(1/tau1)*exp(   (-0.5)* ((udraw./tau1).^2)  );
  f2=(1/tau1)*exp(   (-0.5)* ((udraw./tau2).^2)  );
  fu= q_p*f1 + (1-q_p)*f2;
  q_pt=(q_p*f1)./fu;
    
vardraw = exp(adraw1); 
vardraw=max(vardraw,var_min); % Impose minimum value
